﻿using System;
using System.Diagnostics;
using System.Globalization;
using System.Runtime.InteropServices;
using System.ComponentModel.Design;
using Microsoft.Win32;
using Microsoft.VisualStudio;
using Microsoft.VisualStudio.Shell.Interop;
using Microsoft.VisualStudio.OLE.Interop;
using Microsoft.VisualStudio.Shell;

namespace Firaxis.ModBuddy.SampleModBuddyExtension
{
    /// <summary>
    /// This is the class that implements the package exposed by this assembly.
    ///
    /// The minimum requirement for a class to be considered a valid package for Visual Studio
    /// is to implement the IVsPackage interface and register itself with the shell.
    /// This package uses the helper classes defined inside the Managed Package Framework (MPF)
    /// to do it: it derives from the Package class that provides the implementation of the 
    /// IVsPackage interface and uses the registration attributes defined in the framework to 
    /// register itself and its components with the shell.
    /// </summary>
    // This attribute tells the PkgDef creation utility (CreatePkgDef.exe) that this class is
    // a package.
    [PackageRegistration(UseManagedResourcesOnly = true)]
    // This attribute is used to register the informations needed to show the this package
    // in the Help/About dialog of Visual Studio.
    [InstalledProductRegistration("#110", "#112", "1.0", IconResourceID = 400)]
    // This attribute is needed to let the shell know that this package exposes some menus.
    [ProvideMenuResource("Menus.ctmenu", 1)]
    [Guid(GuidList.guidSampleModBuddyExtensionPkgString)]
    public sealed class SampleModBuddyExtensionPackage : Package
    {
        /// <summary>
        /// Default constructor of the package.
        /// Inside this method you can place any initialization code that does not require 
        /// any Visual Studio service because at this point the package object is created but 
        /// not sited yet inside Visual Studio environment. The place to do all the other 
        /// initialization is the Initialize method.
        /// </summary>
        public SampleModBuddyExtensionPackage()
        {
            Trace.WriteLine(string.Format(CultureInfo.CurrentCulture, "Entering constructor for: {0}", this.ToString()));
        }



        /////////////////////////////////////////////////////////////////////////////
        // Overridden Package Implementation
        #region Package Members

        /// <summary>
        /// Initialization of the package; this method is called right after the package is sited, so this is the place
        /// where you can put all the initialization code that rely on services provided by VisualStudio.
        /// </summary>
        protected override void Initialize()
        {
            Trace.WriteLine (string.Format(CultureInfo.CurrentCulture, "Entering Initialize() of: {0}", this.ToString()));
            base.Initialize();

            AddMenuHandlers();
        }
        #endregion

        /// <summary>
        /// Navigates the specified URL.
        /// </summary>
        /// <param name="url">The URL.</param>
        private void Navigate(string url)
        {
            var webBrowsingService = GetService(typeof(SVsWebBrowsingService)) as IVsWebBrowsingService;

            if (webBrowsingService != null)
            {
                IVsWindowFrame frame;
                ErrorHandler.ThrowOnFailure(webBrowsingService.Navigate(url, 0, out frame));
            }
        }

        /// <summary>
        /// Adds event handlers to all registered menu items.
        /// </summary>
        private void AddMenuHandlers()
        {
            // Add our command handlers for menu (commands must exist in the .vsct file)
            var mcs = GetService(typeof(IMenuCommandService)) as OleMenuCommandService;
            if (null != mcs)
            {
                AddMenuHandler(mcs, GuidList.guidSampleModBuddyExtensionCmdSet, PkgCmdIDList.cmdid2kForums,
                                delegate { Navigate("http://forums.2kgames.com/forums/forumdisplay.php?74-Civilization-V-General-Discussion"); });
            }
        }

        /// <summary>
        /// Adds the menu handler.
        /// </summary>
        /// <param name="menuCommandService">The menu command service.</param>
        /// <param name="menuGroup">The menu group.</param>
        /// <param name="command">The command.</param>
        /// <param name="handler">The handler.</param>
        /// <returns></returns>
        private static MenuCommand AddMenuHandler(IMenuCommandService menuCommandService, Guid menuGroup, int command,
                                                  EventHandler handler)
        {
            var commandId = new CommandID(menuGroup, command);
            var menuItem = new MenuCommand(handler, commandId);
            menuCommandService.AddCommand(menuItem);
            return menuItem;
        }
    }
}
